******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


*********************
* Merge in DHS data *
*********************
use "$internal_dir/data/panel.dta", clear
merge 1:1 country_str year using "$internal_dir/external_data/dhs_nonimmi_final.dta"
	keep if year>=1980 & year<=2004
	drop if _merge==2
	drop _merge
merge 1:1 country_str year using "$internal_dir/external_data/dhs_lpr_final.dta"
	keep if year>=1980 & year<=2004
	drop if _merge==2
	drop _merge
format country_str %50s

*Declare panel
xtset country year


************************
* Create key variables *
************************

*Create moving average of hurricane index
tssmooth ma HI_ma = HI, window(1 1 0)

*Keep relevant years
keep if year>=1980 & year<=2004
local time "i.year trend*"

*Dependent Variables
rename TOT DHS_nonimm
rename total DHS_lpr
local vars "inflows DHS_nonimm DHS_lpr"
foreach var in `vars' {
	gen p_`var' = `var'/population1980
	}
	
*Interaction term
gen p_stock1980 = stock1980/population1980
drop if p_stock==.

*Time variables
local time "i.year c.year#i.country"


*******************
* Finalize sample *
*******************

*Determine country-years and countries with DHS non-immigrant data for any years
xtreg p_DHS_nonimm `time' c.HI_ma##c.p_stock1980, fe cl(country)
	gen nonimm_sample = e(sample)
	bysort country: egen non_imm_country_sample = max(nonimm_sample)

*Determine country-years and countries with DHS LPR data for any years
xtreg p_DHS_lpr `time' c.HI_ma##c.p_stock1980, fe cl(country)
	gen lpr_sample = e(sample)
	bysort country: egen lpr_country_sample = max(lpr_sample)

*Restrict analysis to the set of countries covered by all data sources (RDC & DHS)
keep if lpr_country_sample==1 & non_imm_country_sample==1

*Determine implied immigrant inflows from RDC results	
xtreg p_inflows `time' c.HI_ma##c.p_stock1980, fe cl(country)
local g1_rdc = _b[HI_ma]
local g2_rdc = _b[c.HI_ma#c.p_stock1980]
gen implied_migs_rdc = (`g1_rdc'*HI_ma + `g2_rdc'*HI_ma*p_stock)


***************************************************************************
* Table 6: Compare total RDC inflow, immigrant, and non-immigrant inflows *
***************************************************************************
cap erase "$internal_dir/output/table6.txt"
foreach var in `vars' {
	
	xtreg p_`var' `time' HI_ma, fe cl(country)
		
		*Year range for column title
		sum year if e(sample)==1
		local ymin = r(min)
		local ymax = r(max)

		*Output results
		outreg2 using "$internal_dir/output/table6", append nocons keep(HI_ma) ///
			dec(4) noparen af(g) addtext(Years,"`ymin' to `ymax'") 
	
			
	xtreg p_`var' `time' c.HI_ma##c.p_stock1980, fe cl(country)
		
		*Year range for column title
		sum year if e(sample)==1
		local ymin = r(min)
			local ymin "`ymin'"
		local ymax = r(max)

		*Determine proportion of RDC implied inflows explained by DHS inflow outcome
		local g1_`var' = _b[HI_ma]
		local g2_`var' = _b[c.HI_ma#c.p_stock1980]
		preserve
			gen implied_migs_`var' = (`g1_`var''*HI_ma + `g2_`var''*HI_ma*p_stock)
			gen prop_`var' = implied_migs_`var'/implied_migs_rdc
			collapse prop_`var' population1980 p_stock, by(country)
			sum prop_`var' [aw=population1980]
			local prop_`var' = r(mean)
		restore
	
		*Output results and disclosure statistics
		outreg2 using "$internal_dir/output/table6", append nocons keep(HI_ma c.HI_ma#c.p_stock) ///
			dec(4) adds(Prop,`prop_`var'') ad(4) af(g) noparen addtext(Years,"`ymin' to `ymax'")
	}
	
	
***********************************************
* Table 7: break-down legal immigrant inflows *
***********************************************
cap erase "$internal_dir/output/table7.txt"
rename DHS_lpr total
cap drop p_DHS_lpr
local lpr_vars "total parents spouse children immediate refugee family_sponsored employment_sponsored diversity"

foreach var in `lpr_vars' {

	gen p_lpr_`var' = `var'/population1980
	
	xtreg p_lpr_`var' `time' c.HI_ma##c.p_stock, fe cl(country)
		
		*Year range for column title
		sum year if e(sample)==1
		local ymin = r(min)
		local ymax = r(max)

	
	*Output results and disclosure statistics
	outreg2 using "$internal_dir/output/table7", append nocons keep(HI_ma c.HI_ma#c.p_stock) ///
		dec(4) noparen addtext(Years,"`ymin' to `ymax'")

	}
